/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifier prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
/************ Begin %include sections from the grammar ************************/
#line 4 "grn_ecmascript.lemon"

#ifdef assert
#  undef assert
#endif
#define assert GRN_ASSERT
#line 34 "grn_ecmascript.c"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    grn_expr_parserTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is grn_expr_parserTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    grn_expr_parserARG_SDECL     A static variable declaration for the %extra_argument
**    grn_expr_parserARG_PDECL     A parameter declaration for the %extra_argument
**    grn_expr_parserARG_STORE     Code to store %extra_argument into yypParser
**    grn_expr_parserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_MIN_REDUCE      Maximum value for reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned char
#define YYNOCODE 115
#define YYACTIONTYPE unsigned short int
#define grn_expr_parserTOKENTYPE  int 
typedef union {
  int yyinit;
  grn_expr_parserTOKENTYPE yy0;
  void * yy217;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define grn_expr_parserARG_SDECL  efs_info *efsi ;
#define grn_expr_parserARG_PDECL , efs_info *efsi 
#define grn_expr_parserARG_FETCH  efs_info *efsi  = yypParser->efsi 
#define grn_expr_parserARG_STORE yypParser->efsi  = efsi 
#define YYNSTATE             145
#define YYNRULE              136
#define YY_MAX_SHIFT         144
#define YY_MIN_SHIFTREDUCE   232
#define YY_MAX_SHIFTREDUCE   367
#define YY_MIN_REDUCE        368
#define YY_MAX_REDUCE        503
#define YY_ERROR_ACTION      504
#define YY_ACCEPT_ACTION     505
#define YY_NO_ACTION         506
/************* End control #defines *******************************************/

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if:
**    (1)  The yy_shift_ofst[S]+X value is out of range, or
**    (2)  yy_lookahead[yy_shift_ofst[S]+X] is not equal to X, or
**    (3)  yy_shift_ofst[S] equal YY_SHIFT_USE_DFLT.
** (Implementation note: YY_SHIFT_USE_DFLT is chosen so that
** YY_SHIFT_USE_DFLT+X will be out of range for all possible lookaheads X.
** Hence only tests (1) and (2) need to be evaluated.)
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1794)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */     3,   72,  115,  115,  136,  131,  323,    2,  363,   54,
 /*    10 */    83,  129,    1,  232,   71,  505,   79,  112,   10,  241,
 /*    20 */    79,   75,  112,  112,   91,  126,  125,  139,  138,  137,
 /*    30 */   120,   88,  103,  116,  104,  104,  104,   91,   75,  241,
 /*    40 */   241,   75,   75,  323,   74,  457,   84,   83,  144,    9,
 /*    50 */   236,   71,   66,   65,   53,   52,   51,   69,   68,   67,
 /*    60 */    64,   63,   61,   60,   59,  348,  349,  350,  351,  352,
 /*    70 */     4,  127,   70,   58,   57,   75,  127,  127,   91,  126,
 /*    80 */   125,  139,  138,  137,  120,   88,  103,  116,  104,  104,
 /*    90 */   104,   91,   75,   78,  456,   75,   75,   78,   76,  115,
 /*   100 */   115,  136,  235,  323,    2,  499,   54,   83,  129,    1,
 /*   110 */     5,   71,   78,  118,  110,   82,   78,   75,  118,  118,
 /*   120 */    91,  126,  125,  139,  138,  137,  120,   88,  103,  116,
 /*   130 */   104,  104,  104,   91,   75,  315,  133,   75,   75,    7,
 /*   140 */   300,   62,   77,  346,   73,  110,  133,  362,  136,   66,
 /*   150 */    65,  299,  343,  239,   69,   68,   67,   64,   63,   61,
 /*   160 */    60,   59,  348,  349,  350,  351,  352,    4,   50,   49,
 /*   170 */    48,   47,   46,   45,   44,   43,   42,   41,   40,   39,
 /*   180 */    38,   37,   31,   30,   66,   65,  312,   56,   55,   69,
 /*   190 */    68,   67,   64,   63,   61,   60,   59,  348,  349,  350,
 /*   200 */   351,  352,    4,  111,  238,  313,   75,  314,  314,   91,
 /*   210 */   126,  125,  139,  138,  137,  120,   88,  103,  116,  104,
 /*   220 */   104,  104,   91,   75,   36,   35,   75,   75,    7,  237,
 /*   230 */    62,    6,  346,   73,  309,  240,  357,   28,   75,   87,
 /*   240 */    87,   91,  126,  125,  139,  138,  137,  120,   88,  103,
 /*   250 */   116,  104,  104,  104,   91,   75,  304,  234,   75,   75,
 /*   260 */    11,   87,    7,   23,   62,  233,  346,   73,  297,  298,
 /*   270 */   357,    7,  356,   66,   65,  346,   73,  130,   69,   68,
 /*   280 */    67,   64,   63,   61,   60,   59,  348,  349,  350,  351,
 /*   290 */   352,    4,  354,    7,    8,   62,  135,  346,   73,  345,
 /*   300 */   317,  356,   32,   29,  316,  132,   28,   66,   65,  364,
 /*   310 */    24,   34,   69,   68,   67,   64,   63,   61,   60,   59,
 /*   320 */   348,  349,  350,  351,  352,    4,  353,   26,  355,  348,
 /*   330 */   349,  350,  351,  352,    4,   33,   25,  370,   66,   65,
 /*   340 */   370,  370,  370,   69,   68,   67,   64,   63,   61,   60,
 /*   350 */    59,  348,  349,  350,  351,  352,    4,   75,  314,  314,
 /*   360 */    91,  126,  125,  139,  138,  137,  120,   88,  103,  116,
 /*   370 */   104,  104,  104,   91,   75,  370,  370,   75,   75,  370,
 /*   380 */   370,  370,  370,  370,  370,  311,   28,  370,  370,  370,
 /*   390 */   370,   75,  306,  306,   91,  126,  125,  139,  138,  137,
 /*   400 */   120,   88,  103,  116,  104,  104,  104,   91,   75,  370,
 /*   410 */   370,   75,   75,  370,  370,  370,  370,  370,  114,  118,
 /*   420 */   370,  370,  370,   75,  118,  118,   91,  126,  125,  139,
 /*   430 */   138,  137,  120,   88,  103,  116,  104,  104,  104,   91,
 /*   440 */    75,  121,  303,   75,   75,   75,  121,  121,   91,  126,
 /*   450 */   125,  139,  138,  137,  120,   88,  103,  116,  104,  104,
 /*   460 */   104,   91,   75,  370,  370,   75,   75,  370,    7,  370,
 /*   470 */    62,  127,  346,   73,  370,   75,  127,  127,   91,  126,
 /*   480 */   125,  139,  138,  137,  120,   88,  103,  116,  104,  104,
 /*   490 */   104,   91,   75,  455,  370,   75,   75,    7,  370,   62,
 /*   500 */   370,  346,   73,  370,  370,  370,  370,  370,  370,   28,
 /*   510 */   370,  370,  370,   66,   65,  370,  370,  370,   69,   68,
 /*   520 */    67,   64,   63,   61,   60,   59,  348,  349,  128,  351,
 /*   530 */   352,    4,  370,  370,  370,  370,  370,  370,  370,  370,
 /*   540 */   370,  370,   66,   65,  370,  370,  370,   69,   68,   67,
 /*   550 */    64,   63,   61,   60,   59,  348,  349,  350,  351,  352,
 /*   560 */     4,   75,  360,  360,   91,  126,  125,  139,  138,  137,
 /*   570 */   120,   88,  103,  116,  104,  104,  104,   91,   75,  370,
 /*   580 */   370,   75,   75,   75,  359,  359,   91,  126,  125,  139,
 /*   590 */   138,  137,  120,   88,  103,  116,  104,  104,  104,   91,
 /*   600 */    75,  370,  370,   75,   75,   75,  254,  254,   91,  126,
 /*   610 */   125,  139,  138,  137,  120,   88,  103,  116,  104,  104,
 /*   620 */   104,   91,   75,  370,  370,   75,   75,   75,  253,  253,
 /*   630 */    91,  126,  125,  139,  138,  137,  120,   88,  103,  116,
 /*   640 */   104,  104,  104,   91,   75,  370,  370,   75,   75,   75,
 /*   650 */   252,  252,   91,  126,  125,  139,  138,  137,  120,   88,
 /*   660 */   103,  116,  104,  104,  104,   91,   75,  370,  370,   75,
 /*   670 */    75,   75,  251,  251,   91,  126,  125,  139,  138,  137,
 /*   680 */   120,   88,  103,  116,  104,  104,  104,   91,   75,  370,
 /*   690 */   370,   75,   75,   75,  250,  250,   91,  126,  125,  139,
 /*   700 */   138,  137,  120,   88,  103,  116,  104,  104,  104,   91,
 /*   710 */    75,  370,  370,   75,   75,   75,  249,  249,   91,  126,
 /*   720 */   125,  139,  138,  137,  120,   88,  103,  116,  104,  104,
 /*   730 */   104,   91,   75,  370,  370,   75,   75,   75,  248,  248,
 /*   740 */    91,  126,  125,  139,  138,  137,  120,   88,  103,  116,
 /*   750 */   104,  104,  104,   91,   75,  370,  370,   75,   75,   75,
 /*   760 */   247,  247,   91,  126,  125,  139,  138,  137,  120,   88,
 /*   770 */   103,  116,  104,  104,  104,   91,   75,  370,  370,   75,
 /*   780 */    75,   75,  246,  246,   91,  126,  125,  139,  138,  137,
 /*   790 */   120,   88,  103,  116,  104,  104,  104,   91,   75,  370,
 /*   800 */   370,   75,   75,   75,  245,  245,   91,  126,  125,  139,
 /*   810 */   138,  137,  120,   88,  103,  116,  104,  104,  104,   91,
 /*   820 */    75,  370,  370,   75,   75,   75,  244,  244,   91,  126,
 /*   830 */   125,  139,  138,  137,  120,   88,  103,  116,  104,  104,
 /*   840 */   104,   91,   75,  370,  370,   75,   75,   75,  307,  307,
 /*   850 */    91,  126,  125,  139,  138,  137,  120,   88,  103,  116,
 /*   860 */   104,  104,  104,   91,   75,  370,  370,   75,   75,   75,
 /*   870 */   302,  302,   91,  126,  125,  139,  138,  137,  120,   88,
 /*   880 */   103,  116,  104,  104,  104,   91,   75,  370,  370,   75,
 /*   890 */    75,   75,  255,  255,   91,  126,  125,  139,  138,  137,
 /*   900 */   120,   88,  103,  116,  104,  104,  104,   91,   75,  370,
 /*   910 */   370,   75,   75,   75,  143,  143,   91,  126,  125,  139,
 /*   920 */   138,  137,  120,   88,  103,  116,  104,  104,  104,   91,
 /*   930 */    75,  370,  370,   75,   75,   75,  243,  243,   91,  126,
 /*   940 */   125,  139,  138,  137,  120,   88,  103,  116,  104,  104,
 /*   950 */   104,   91,   75,  370,  370,   75,   75,   75,  242,  242,
 /*   960 */    91,  126,  125,  139,  138,  137,  120,   88,  103,  116,
 /*   970 */   104,  104,  104,   91,   75,  370,   75,   75,   75,  122,
 /*   980 */   370,  113,  139,  138,  137,  120,   88,  103,  116,  104,
 /*   990 */   104,  104,  122,   75,  370,   75,   75,   75,  122,  370,
 /*  1000 */   370,  134,  138,  137,  120,   88,  103,  116,  104,  104,
 /*  1010 */   104,  122,   75,  370,   75,   75,   75,  122,  370,  370,
 /*  1020 */   142,  138,  137,  120,   88,  103,  116,  104,  104,  104,
 /*  1030 */   122,   75,  370,   75,   75,   75,  122,  370,  370,  370,
 /*  1040 */   141,  137,  120,   88,  103,  116,  104,  104,  104,  122,
 /*  1050 */    75,  370,   75,   75,   75,  122,  370,  370,  370,  370,
 /*  1060 */   140,  120,   88,  103,  116,  104,  104,  104,  122,   75,
 /*  1070 */   370,  370,   75,   75,  370,  370,  370,  370,   27,   22,
 /*  1080 */    21,   20,   19,   18,   17,   16,   15,   14,   13,   12,
 /*  1090 */    75,  370,  370,  122,  370,  370,  370,  370,  370,  124,
 /*  1100 */    88,  103,  116,  104,  104,  104,  122,   75,  370,  370,
 /*  1110 */    75,   75,   75,  370,  370,  122,  370,  370,  370,  370,
 /*  1120 */   297,  298,   89,  103,  116,  104,  104,  104,  122,   75,
 /*  1130 */   370,   75,   75,   75,  122,  370,  370,  370,  370,  370,
 /*  1140 */   370,   90,  103,  116,  104,  104,  104,  122,   75,  370,
 /*  1150 */   370,   75,   75,  370,  370,   86,   85,   81,   80,  323,
 /*  1160 */    74,  324,   84,   83,  144,    9,  454,   71,  370,   86,
 /*  1170 */    85,   81,   80,  323,   74,  370,   84,   83,  144,    9,
 /*  1180 */   370,   71,  370,   75,  370,  370,  122,  370,  370,  370,
 /*  1190 */   370,  370,  370,  370,   92,  116,  104,  104,  104,  122,
 /*  1200 */    75,  370,  370,   75,   75,   75,  370,  370,  122,  370,
 /*  1210 */   370,  370,  370,  370,  370,  370,   93,  116,  104,  104,
 /*  1220 */   104,  122,   75,  370,  370,   75,   75,   75,  370,  370,
 /*  1230 */   122,  370,  370,  370,  370,  370,  370,  370,   94,  116,
 /*  1240 */   104,  104,  104,  122,   75,  370,   75,   75,   75,  122,
 /*  1250 */   370,  370,  370,  370,  370,  370,  370,   95,  116,  104,
 /*  1260 */   104,  104,  122,   75,  370,   75,   75,   75,  122,  370,
 /*  1270 */   370,  370,  370,  370,  370,  370,   96,  116,  104,  104,
 /*  1280 */   104,  122,   75,  370,   75,   75,   75,  122,  370,  370,
 /*  1290 */   370,  370,  370,  370,  370,   97,  116,  104,  104,  104,
 /*  1300 */   122,   75,  370,   75,   75,   75,  122,  370,  370,  370,
 /*  1310 */   370,  370,  370,  370,   98,  116,  104,  104,  104,  122,
 /*  1320 */    75,  370,   75,   75,   75,  122,  370,  370,  370,  370,
 /*  1330 */   370,  370,  370,   99,  116,  104,  104,  104,  122,   75,
 /*  1340 */   370,   75,   75,   75,  122,  370,  370,  370,  370,  370,
 /*  1350 */   370,  370,  100,  116,  104,  104,  104,  122,   75,  370,
 /*  1360 */    75,   75,   75,  122,  370,  370,  370,  370,  370,  370,
 /*  1370 */   370,  101,  116,  104,  104,  104,  122,   75,  370,   75,
 /*  1380 */    75,   75,  122,  370,  370,  370,  370,  370,  370,  370,
 /*  1390 */   102,  116,  104,  104,  104,  122,   75,  370,   75,   75,
 /*  1400 */    75,  122,  370,  370,  370,  370,  370,  370,  370,  105,
 /*  1410 */   116,  104,  104,  104,  122,   75,  370,   75,   75,   75,
 /*  1420 */   122,  370,  370,  370,  370,  370,  370,  370,  107,  116,
 /*  1430 */   104,  104,  104,  122,   75,  370,   75,   75,   75,  122,
 /*  1440 */   370,  370,  370,  370,  370,  370,  370,  109,  116,  104,
 /*  1450 */   104,  104,  122,   75,  370,   75,   75,   75,  122,  370,
 /*  1460 */   370,  370,  370,  370,  370,  370,  370,  117,  104,  104,
 /*  1470 */   104,  122,   75,  370,   75,   75,   75,  122,  370,  370,
 /*  1480 */   370,  370,  370,  370,  370,  370,  119,  104,  104,  104,
 /*  1490 */   122,   75,  370,   75,   75,   75,  122,  370,  370,  370,
 /*  1500 */   237,   75,  370,  370,  122,  123,  104,  104,  104,  122,
 /*  1510 */    75,  370,  370,   75,   75,  293,  293,  122,   75,  370,
 /*  1520 */    75,   75,   75,  122,  370,  370,  370,  370,  370,  370,
 /*  1530 */   370,  370,  370,  106,  106,  106,  122,   75,  370,   75,
 /*  1540 */    75,   75,  122,  370,  370,  370,  370,  370,  370,  370,
 /*  1550 */   370,  370,  108,  108,  108,  122,   75,  370,   75,   75,
 /*  1560 */    75,  122,  370,  370,  370,  370,  370,  370,  370,  370,
 /*  1570 */   370,  370,  285,  285,  122,   75,  370,   75,   75,   75,
 /*  1580 */   122,  370,  370,  370,  370,   75,  370,  370,  122,  370,
 /*  1590 */   370,  284,  284,  122,   75,  370,  370,   75,   75,  296,
 /*  1600 */   296,  122,   75,  370,   75,   75,   75,  122,  370,  370,
 /*  1610 */   370,  370,  370,  370,  370,  370,  370,  370,  295,  295,
 /*  1620 */   122,   75,  370,   75,   75,   75,  122,  370,  370,  370,
 /*  1630 */   370,  370,  370,  370,  370,  370,  370,  294,  294,  122,
 /*  1640 */    75,  370,   75,   75,   75,  122,  370,  370,  370,  370,
 /*  1650 */   370,  370,  370,  370,  370,  370,  293,  293,  122,   75,
 /*  1660 */   370,   75,   75,   75,  122,  370,  370,  370,  370,   75,
 /*  1670 */   370,  370,  122,  370,  370,  292,  292,  122,   75,  370,
 /*  1680 */   370,   75,   75,  291,  291,  122,   75,  370,   75,   75,
 /*  1690 */    75,  122,  370,  370,  370,  370,  370,  370,  370,  370,
 /*  1700 */   370,  370,  290,  290,  122,   75,  370,   75,   75,   75,
 /*  1710 */   122,  370,  370,  370,  370,  370,  370,  370,  370,  370,
 /*  1720 */   370,  289,  289,  122,   75,  370,   75,   75,   75,  122,
 /*  1730 */   370,  370,  370,  370,  370,  370,  370,  370,  370,  370,
 /*  1740 */   288,  288,  122,   75,  370,   75,   75,   75,  122,  370,
 /*  1750 */   370,  370,  370,   75,  370,  370,  122,  370,  370,  287,
 /*  1760 */   287,  122,   75,  370,  370,   75,   75,  286,  286,  122,
 /*  1770 */    75,  370,   75,   75,   75,  122,  370,  370,  370,  370,
 /*  1780 */   370,  370,  370,  370,  370,  370,  283,  283,  122,   75,
 /*  1790 */   370,  370,   75,   75,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     1,    2,  107,  108,  109,   12,    7,    8,   68,   10,
 /*    10 */    11,   12,   13,   82,   15,   77,   78,   79,  105,   83,
 /*    20 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*    30 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  103,
 /*    40 */   104,  103,  104,    7,    8,    0,   10,   11,   12,   13,
 /*    50 */    82,   15,   53,   54,   50,   51,   52,   58,   59,   60,
 /*    60 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*    70 */    71,   79,   55,   56,   57,   83,   84,   85,   86,   87,
 /*    80 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*    90 */    98,   99,  100,   78,    0,  103,  104,   82,   53,  107,
 /*   100 */   108,  109,   82,    7,    8,   30,   10,   11,   12,   13,
 /*   110 */    16,   15,   78,   79,   81,   11,   82,   83,   84,   85,
 /*   120 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   130 */    96,   97,   98,   99,  100,  112,  113,  103,  104,    8,
 /*   140 */    14,   10,   16,   12,   13,  112,  113,  108,  109,   53,
 /*   150 */    54,  101,  102,   82,   58,   59,   60,   61,   62,   63,
 /*   160 */    64,   65,   66,   67,   68,   69,   70,   71,   36,   37,
 /*   170 */    38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
 /*   180 */    48,   49,    3,    4,   53,   54,   55,   53,   54,   58,
 /*   190 */    59,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   200 */    69,   70,   71,   80,   82,   74,   83,   84,   85,   86,
 /*   210 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   220 */    97,   98,   99,  100,   34,   35,  103,  104,    8,   82,
 /*   230 */    10,    8,   12,   13,  111,   14,   16,   16,   83,   84,
 /*   240 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   250 */    95,   96,   97,   98,   99,  100,    9,   82,  103,  104,
 /*   260 */   105,  106,    8,   16,   10,   82,   12,   13,   59,   60,
 /*   270 */    16,    8,   16,   53,   54,   12,   13,   41,   58,   59,
 /*   280 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   290 */    70,   71,   72,    8,   71,   10,   73,   12,   13,    9,
 /*   300 */    68,   16,   31,    5,   66,   55,   16,   53,   54,   12,
 /*   310 */    30,   33,   58,   59,   60,   61,   62,   63,   64,   65,
 /*   320 */    66,   67,   68,   69,   70,   71,   72,   29,   72,   66,
 /*   330 */    67,   68,   69,   70,   71,   32,   30,  114,   53,   54,
 /*   340 */   114,  114,  114,   58,   59,   60,   61,   62,   63,   64,
 /*   350 */    65,   66,   67,   68,   69,   70,   71,   83,   84,   85,
 /*   360 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   370 */    96,   97,   98,   99,  100,  114,  114,  103,  104,  114,
 /*   380 */   114,  114,  114,  114,  114,  111,   16,  114,  114,  114,
 /*   390 */   114,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   400 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  114,
 /*   410 */   114,  103,  104,  114,  114,  114,  114,  114,  110,   79,
 /*   420 */   114,  114,  114,   83,   84,   85,   86,   87,   88,   89,
 /*   430 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   440 */   100,   79,   72,  103,  104,   83,   84,   85,   86,   87,
 /*   450 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   460 */    98,   99,  100,  114,  114,  103,  104,  114,    8,  114,
 /*   470 */    10,   79,   12,   13,  114,   83,   84,   85,   86,   87,
 /*   480 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   490 */    98,   99,  100,    0,  114,  103,  104,    8,  114,   10,
 /*   500 */   114,   12,   13,  114,  114,  114,  114,  114,  114,   16,
 /*   510 */   114,  114,  114,   53,   54,  114,  114,  114,   58,   59,
 /*   520 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   530 */    70,   71,  114,  114,  114,  114,  114,  114,  114,  114,
 /*   540 */   114,  114,   53,   54,  114,  114,  114,   58,   59,   60,
 /*   550 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   560 */    71,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   570 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  114,
 /*   580 */   114,  103,  104,   83,   84,   85,   86,   87,   88,   89,
 /*   590 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   600 */   100,  114,  114,  103,  104,   83,   84,   85,   86,   87,
 /*   610 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   620 */    98,   99,  100,  114,  114,  103,  104,   83,   84,   85,
 /*   630 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   640 */    96,   97,   98,   99,  100,  114,  114,  103,  104,   83,
 /*   650 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   660 */    94,   95,   96,   97,   98,   99,  100,  114,  114,  103,
 /*   670 */   104,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   680 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  114,
 /*   690 */   114,  103,  104,   83,   84,   85,   86,   87,   88,   89,
 /*   700 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   710 */   100,  114,  114,  103,  104,   83,   84,   85,   86,   87,
 /*   720 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   730 */    98,   99,  100,  114,  114,  103,  104,   83,   84,   85,
 /*   740 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   750 */    96,   97,   98,   99,  100,  114,  114,  103,  104,   83,
 /*   760 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   770 */    94,   95,   96,   97,   98,   99,  100,  114,  114,  103,
 /*   780 */   104,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   790 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  114,
 /*   800 */   114,  103,  104,   83,   84,   85,   86,   87,   88,   89,
 /*   810 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   820 */   100,  114,  114,  103,  104,   83,   84,   85,   86,   87,
 /*   830 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   840 */    98,   99,  100,  114,  114,  103,  104,   83,   84,   85,
 /*   850 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   860 */    96,   97,   98,   99,  100,  114,  114,  103,  104,   83,
 /*   870 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   880 */    94,   95,   96,   97,   98,   99,  100,  114,  114,  103,
 /*   890 */   104,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   900 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  114,
 /*   910 */   114,  103,  104,   83,   84,   85,   86,   87,   88,   89,
 /*   920 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   930 */   100,  114,  114,  103,  104,   83,   84,   85,   86,   87,
 /*   940 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   950 */    98,   99,  100,  114,  114,  103,  104,   83,   84,   85,
 /*   960 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   970 */    96,   97,   98,   99,  100,  114,   83,  103,  104,   86,
 /*   980 */   114,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   990 */    97,   98,   99,  100,  114,   83,  103,  104,   86,  114,
 /*  1000 */   114,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*  1010 */    98,   99,  100,  114,   83,  103,  104,   86,  114,  114,
 /*  1020 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*  1030 */    99,  100,  114,   83,  103,  104,   86,  114,  114,  114,
 /*  1040 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*  1050 */   100,  114,   83,  103,  104,   86,  114,  114,  114,  114,
 /*  1060 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*  1070 */   114,  114,  103,  104,  114,  114,  114,  114,   17,   18,
 /*  1080 */    19,   20,   21,   22,   23,   24,   25,   26,   27,   28,
 /*  1090 */    83,  114,  114,   86,  114,  114,  114,  114,  114,   92,
 /*  1100 */    93,   94,   95,   96,   97,   98,   99,  100,  114,  114,
 /*  1110 */   103,  104,   83,  114,  114,   86,  114,  114,  114,  114,
 /*  1120 */    59,   60,   93,   94,   95,   96,   97,   98,   99,  100,
 /*  1130 */   114,   83,  103,  104,   86,  114,  114,  114,  114,  114,
 /*  1140 */   114,   93,   94,   95,   96,   97,   98,   99,  100,  114,
 /*  1150 */   114,  103,  104,  114,  114,    3,    4,    5,    6,    7,
 /*  1160 */     8,    9,   10,   11,   12,   13,    0,   15,  114,    3,
 /*  1170 */     4,    5,    6,    7,    8,  114,   10,   11,   12,   13,
 /*  1180 */   114,   15,  114,   83,  114,  114,   86,  114,  114,  114,
 /*  1190 */   114,  114,  114,  114,   94,   95,   96,   97,   98,   99,
 /*  1200 */   100,  114,  114,  103,  104,   83,  114,  114,   86,  114,
 /*  1210 */   114,  114,  114,  114,  114,  114,   94,   95,   96,   97,
 /*  1220 */    98,   99,  100,  114,  114,  103,  104,   83,  114,  114,
 /*  1230 */    86,  114,  114,  114,  114,  114,  114,  114,   94,   95,
 /*  1240 */    96,   97,   98,   99,  100,  114,   83,  103,  104,   86,
 /*  1250 */   114,  114,  114,  114,  114,  114,  114,   94,   95,   96,
 /*  1260 */    97,   98,   99,  100,  114,   83,  103,  104,   86,  114,
 /*  1270 */   114,  114,  114,  114,  114,  114,   94,   95,   96,   97,
 /*  1280 */    98,   99,  100,  114,   83,  103,  104,   86,  114,  114,
 /*  1290 */   114,  114,  114,  114,  114,   94,   95,   96,   97,   98,
 /*  1300 */    99,  100,  114,   83,  103,  104,   86,  114,  114,  114,
 /*  1310 */   114,  114,  114,  114,   94,   95,   96,   97,   98,   99,
 /*  1320 */   100,  114,   83,  103,  104,   86,  114,  114,  114,  114,
 /*  1330 */   114,  114,  114,   94,   95,   96,   97,   98,   99,  100,
 /*  1340 */   114,   83,  103,  104,   86,  114,  114,  114,  114,  114,
 /*  1350 */   114,  114,   94,   95,   96,   97,   98,   99,  100,  114,
 /*  1360 */    83,  103,  104,   86,  114,  114,  114,  114,  114,  114,
 /*  1370 */   114,   94,   95,   96,   97,   98,   99,  100,  114,   83,
 /*  1380 */   103,  104,   86,  114,  114,  114,  114,  114,  114,  114,
 /*  1390 */    94,   95,   96,   97,   98,   99,  100,  114,   83,  103,
 /*  1400 */   104,   86,  114,  114,  114,  114,  114,  114,  114,   94,
 /*  1410 */    95,   96,   97,   98,   99,  100,  114,   83,  103,  104,
 /*  1420 */    86,  114,  114,  114,  114,  114,  114,  114,   94,   95,
 /*  1430 */    96,   97,   98,   99,  100,  114,   83,  103,  104,   86,
 /*  1440 */   114,  114,  114,  114,  114,  114,  114,   94,   95,   96,
 /*  1450 */    97,   98,   99,  100,  114,   83,  103,  104,   86,  114,
 /*  1460 */   114,  114,  114,  114,  114,  114,  114,   95,   96,   97,
 /*  1470 */    98,   99,  100,  114,   83,  103,  104,   86,  114,  114,
 /*  1480 */   114,  114,  114,  114,  114,  114,   95,   96,   97,   98,
 /*  1490 */    99,  100,  114,   83,  103,  104,   86,  114,  114,  114,
 /*  1500 */    82,   83,  114,  114,   86,   95,   96,   97,   98,   99,
 /*  1510 */   100,  114,  114,  103,  104,   97,   98,   99,  100,  114,
 /*  1520 */    83,  103,  104,   86,  114,  114,  114,  114,  114,  114,
 /*  1530 */   114,  114,  114,   96,   97,   98,   99,  100,  114,   83,
 /*  1540 */   103,  104,   86,  114,  114,  114,  114,  114,  114,  114,
 /*  1550 */   114,  114,   96,   97,   98,   99,  100,  114,   83,  103,
 /*  1560 */   104,   86,  114,  114,  114,  114,  114,  114,  114,  114,
 /*  1570 */   114,  114,   97,   98,   99,  100,  114,   83,  103,  104,
 /*  1580 */    86,  114,  114,  114,  114,   83,  114,  114,   86,  114,
 /*  1590 */   114,   97,   98,   99,  100,  114,  114,  103,  104,   97,
 /*  1600 */    98,   99,  100,  114,   83,  103,  104,   86,  114,  114,
 /*  1610 */   114,  114,  114,  114,  114,  114,  114,  114,   97,   98,
 /*  1620 */    99,  100,  114,   83,  103,  104,   86,  114,  114,  114,
 /*  1630 */   114,  114,  114,  114,  114,  114,  114,   97,   98,   99,
 /*  1640 */   100,  114,   83,  103,  104,   86,  114,  114,  114,  114,
 /*  1650 */   114,  114,  114,  114,  114,  114,   97,   98,   99,  100,
 /*  1660 */   114,   83,  103,  104,   86,  114,  114,  114,  114,   83,
 /*  1670 */   114,  114,   86,  114,  114,   97,   98,   99,  100,  114,
 /*  1680 */   114,  103,  104,   97,   98,   99,  100,  114,   83,  103,
 /*  1690 */   104,   86,  114,  114,  114,  114,  114,  114,  114,  114,
 /*  1700 */   114,  114,   97,   98,   99,  100,  114,   83,  103,  104,
 /*  1710 */    86,  114,  114,  114,  114,  114,  114,  114,  114,  114,
 /*  1720 */   114,   97,   98,   99,  100,  114,   83,  103,  104,   86,
 /*  1730 */   114,  114,  114,  114,  114,  114,  114,  114,  114,  114,
 /*  1740 */    97,   98,   99,  100,  114,   83,  103,  104,   86,  114,
 /*  1750 */   114,  114,  114,   83,  114,  114,   86,  114,  114,   97,
 /*  1760 */    98,   99,  100,  114,  114,  103,  104,   97,   98,   99,
 /*  1770 */   100,  114,   83,  103,  104,   86,  114,  114,  114,  114,
 /*  1780 */   114,  114,  114,  114,  114,  114,   97,   98,   99,  100,
 /*  1790 */   114,  114,  103,  104,
};
#define YY_SHIFT_USE_DFLT (1794)
#define YY_SHIFT_COUNT    (144)
#define YY_SHIFT_MIN      (-60)
#define YY_SHIFT_MAX      (1166)
static const short yy_shift_ofst[] = {
 /*     0 */    -1,  460,   96,  131,  285,  131,  489,  489,  489,  489,
 /*    10 */   220,  254,  489,  489,  489,  489,  489,  489,  489,  489,
 /*    20 */   489,  489,  489,  489,  489,  489,  489,  489,  489,  489,
 /*    30 */   489,  489,  489,  489,  489,  489,  489,  489,  489,  489,
 /*    40 */   489,  489,  489,  489,  489,  489,  489,  489,  489,  489,
 /*    50 */   489,  489,  489,  489,   96,  489,  489,  489,  489,  489,
 /*    60 */   489,  489,  489,  489,  489,  489,  489,  489,  489,  489,
 /*    70 */   489,  263,   -7,  -60,   36,  223,   -7,  -60, 1152, 1166,
 /*    80 */    36,   36,   36,   36,   36,   36,   36,  256,  132,  132,
 /*    90 */   132, 1061,    4,    4,    4,    4,    4,    4,    4,    4,
 /*   100 */     4,    4,    4,    4,   17,    4,   17,    4,   17,    4,
 /*   110 */    45,   94,  493,  179,  247,  126,  134,  134,  290,  134,
 /*   120 */   190,  370,  209,  134,  190,  179,  298,  221,   75,  104,
 /*   130 */   232,  236,  238,  250,  271,  297,  280,  278,  303,  271,
 /*   140 */   278,  303,  271,  306,  104,
};
#define YY_REDUCE_USE_DFLT (-106)
#define YY_REDUCE_COUNT (87)
#define YY_REDUCE_MIN   (-105)
#define YY_REDUCE_MAX   (1689)
static const short yy_reduce_ofst[] = {
 /*     0 */   -62,   -8,   34,  123,  155,  274,  308,  340,  362,  392,
 /*    10 */   478,  500,  522,  544,  566,  588,  610,  632,  654,  676,
 /*    20 */   698,  720,  742,  764,  786,  808,  830,  852,  874,  893,
 /*    30 */   912,  931,  950,  969, 1007, 1029, 1048, 1100, 1122, 1144,
 /*    40 */  1163, 1182, 1201, 1220, 1239, 1258, 1277, 1296, 1315, 1334,
 /*    50 */  1353, 1372, 1391, 1410, 1418, 1437, 1456, 1475, 1494, 1502,
 /*    60 */  1521, 1540, 1559, 1578, 1586, 1605, 1624, 1643, 1662, 1670,
 /*    70 */  1689,  -64,   33, -105,   15,   50,   23,   39,  -69,  -69,
 /*    80 */   -32,   20,   71,  122,  147,  175,  183,  -87,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   504,  437,  504,  444,  504,  446,  441,  504,  504,  504,
 /*    10 */   504,  504,  504,  504,  504,  504,  504,  504,  504,  504,
 /*    20 */   504,  504,  504,  504,  504,  504,  504,  504,  504,  504,
 /*    30 */   504,  504,  504,  504,  504,  504,  504,  504,  504,  504,
 /*    40 */   504,  504,  504,  504,  504,  504,  504,  504,  504,  504,
 /*    50 */   504,  504,  504,  504,  504,  504,  504,  504,  504,  504,
 /*    60 */   504,  504,  504,  504,  504,  504,  504,  504,  504,  504,
 /*    70 */   504,  504,  501,  437,  504,  477,  504,  504,  504,  504,
 /*    80 */   504,  504,  504,  504,  504,  504,  504,  504,  469,  399,
 /*    90 */   398,  475,  413,  412,  411,  410,  409,  408,  407,  406,
 /*   100 */   405,  404,  403,  470,  472,  402,  418,  401,  417,  400,
 /*   110 */   504,  504,  504,  392,  504,  504,  471,  416,  504,  415,
 /*   120 */   468,  504,  475,  414,  397,  464,  463,  504,  486,  482,
 /*   130 */   504,  504,  504,  503,  394,  504,  504,  467,  466,  465,
 /*   140 */   396,  395,  393,  504,  504,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  grn_expr_parserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "START_OUTPUT_COLUMNS",  "START_ADJUSTER",  "LOGICAL_AND", 
  "LOGICAL_AND_NOT",  "LOGICAL_OR",    "NEGATIVE",      "QSTRING",     
  "PARENL",        "PARENR",        "ADJUST",        "RELATIVE_OP", 
  "IDENTIFIER",    "BRACEL",        "BRACER",        "EVAL",        
  "COMMA",         "ASSIGN",        "STAR_ASSIGN",   "SLASH_ASSIGN",
  "MOD_ASSIGN",    "PLUS_ASSIGN",   "MINUS_ASSIGN",  "SHIFTL_ASSIGN",
  "SHIFTR_ASSIGN",  "SHIFTRR_ASSIGN",  "AND_ASSIGN",    "XOR_ASSIGN",  
  "OR_ASSIGN",     "QUESTION",      "COLON",         "BITWISE_OR",  
  "BITWISE_XOR",   "BITWISE_AND",   "EQUAL",         "NOT_EQUAL",   
  "LESS",          "GREATER",       "LESS_EQUAL",    "GREATER_EQUAL",
  "IN",            "MATCH",         "NEAR",          "NEAR2",       
  "SIMILAR",       "TERM_EXTRACT",  "LCP",           "PREFIX",      
  "SUFFIX",        "REGEXP",        "SHIFTL",        "SHIFTR",      
  "SHIFTRR",       "PLUS",          "MINUS",         "STAR",        
  "SLASH",         "MOD",           "DELETE",        "INCR",        
  "DECR",          "NOT",           "BITWISE_NOT",   "EXACT",       
  "PARTIAL",       "UNSPLIT",       "DECIMAL",       "HEX_INTEGER", 
  "STRING",        "BOOLEAN",       "NULL",          "BRACKETL",    
  "BRACKETR",      "DOT",           "NONEXISTENT_COLUMN",  "error",       
  "suppress_unused_variable_warning",  "input",         "query",         "expression",  
  "output_columns",  "adjuster",      "query_element",  "primary_expression",
  "assignment_expression",  "conditional_expression",  "lefthand_side_expression",  "logical_or_expression",
  "logical_and_expression",  "bitwise_or_expression",  "bitwise_xor_expression",  "bitwise_and_expression",
  "equality_expression",  "relational_expression",  "shift_expression",  "additive_expression",
  "multiplicative_expression",  "unary_expression",  "postfix_expression",  "call_expression",
  "member_expression",  "arguments",     "member_expression_part",  "object_literal",
  "array_literal",  "elision",       "element_list",  "property_name_and_value_list",
  "property_name_and_value",  "property_name",  "argument_list",  "output_column",
  "adjust_expression",  "adjust_match_expression",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "query ::= query query_element",
 /*   1 */ "query ::= query LOGICAL_AND query_element",
 /*   2 */ "query ::= query LOGICAL_AND_NOT query_element",
 /*   3 */ "query ::= query LOGICAL_OR query_element",
 /*   4 */ "query ::= query NEGATIVE query_element",
 /*   5 */ "query_element ::= ADJUST query_element",
 /*   6 */ "query_element ::= RELATIVE_OP query_element",
 /*   7 */ "query_element ::= IDENTIFIER RELATIVE_OP query_element",
 /*   8 */ "query_element ::= BRACEL expression BRACER",
 /*   9 */ "query_element ::= EVAL primary_expression",
 /*  10 */ "expression ::= expression COMMA assignment_expression",
 /*  11 */ "assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression",
 /*  12 */ "assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression",
 /*  13 */ "assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression",
 /*  14 */ "assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression",
 /*  15 */ "assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression",
 /*  16 */ "assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression",
 /*  17 */ "assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression",
 /*  18 */ "assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression",
 /*  19 */ "assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression",
 /*  20 */ "assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression",
 /*  21 */ "assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression",
 /*  22 */ "assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression",
 /*  23 */ "conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression",
 /*  24 */ "logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression",
 /*  25 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression",
 /*  26 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression",
 /*  27 */ "bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression",
 /*  28 */ "bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression",
 /*  29 */ "bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression",
 /*  30 */ "equality_expression ::= equality_expression EQUAL relational_expression",
 /*  31 */ "equality_expression ::= equality_expression NOT_EQUAL relational_expression",
 /*  32 */ "relational_expression ::= relational_expression LESS shift_expression",
 /*  33 */ "relational_expression ::= relational_expression GREATER shift_expression",
 /*  34 */ "relational_expression ::= relational_expression LESS_EQUAL shift_expression",
 /*  35 */ "relational_expression ::= relational_expression GREATER_EQUAL shift_expression",
 /*  36 */ "relational_expression ::= relational_expression IN shift_expression",
 /*  37 */ "relational_expression ::= relational_expression MATCH shift_expression",
 /*  38 */ "relational_expression ::= relational_expression NEAR shift_expression",
 /*  39 */ "relational_expression ::= relational_expression NEAR2 shift_expression",
 /*  40 */ "relational_expression ::= relational_expression SIMILAR shift_expression",
 /*  41 */ "relational_expression ::= relational_expression TERM_EXTRACT shift_expression",
 /*  42 */ "relational_expression ::= relational_expression LCP shift_expression",
 /*  43 */ "relational_expression ::= relational_expression PREFIX shift_expression",
 /*  44 */ "relational_expression ::= relational_expression SUFFIX shift_expression",
 /*  45 */ "relational_expression ::= relational_expression REGEXP shift_expression",
 /*  46 */ "shift_expression ::= shift_expression SHIFTL additive_expression",
 /*  47 */ "shift_expression ::= shift_expression SHIFTR additive_expression",
 /*  48 */ "shift_expression ::= shift_expression SHIFTRR additive_expression",
 /*  49 */ "additive_expression ::= additive_expression PLUS multiplicative_expression",
 /*  50 */ "additive_expression ::= additive_expression MINUS multiplicative_expression",
 /*  51 */ "multiplicative_expression ::= multiplicative_expression STAR unary_expression",
 /*  52 */ "multiplicative_expression ::= multiplicative_expression SLASH unary_expression",
 /*  53 */ "multiplicative_expression ::= multiplicative_expression MOD unary_expression",
 /*  54 */ "unary_expression ::= DELETE unary_expression",
 /*  55 */ "unary_expression ::= INCR unary_expression",
 /*  56 */ "unary_expression ::= DECR unary_expression",
 /*  57 */ "unary_expression ::= PLUS unary_expression",
 /*  58 */ "unary_expression ::= MINUS unary_expression",
 /*  59 */ "unary_expression ::= NOT unary_expression",
 /*  60 */ "unary_expression ::= BITWISE_NOT unary_expression",
 /*  61 */ "unary_expression ::= ADJUST unary_expression",
 /*  62 */ "unary_expression ::= EXACT unary_expression",
 /*  63 */ "unary_expression ::= PARTIAL unary_expression",
 /*  64 */ "unary_expression ::= UNSPLIT unary_expression",
 /*  65 */ "postfix_expression ::= lefthand_side_expression INCR",
 /*  66 */ "postfix_expression ::= lefthand_side_expression DECR",
 /*  67 */ "call_expression ::= member_expression arguments",
 /*  68 */ "object_literal ::= BRACEL property_name_and_value_list BRACER",
 /*  69 */ "property_name_and_value_list ::=",
 /*  70 */ "property_name_and_value ::= property_name COLON assignment_expression",
 /*  71 */ "member_expression_part ::= BRACKETL expression BRACKETR",
 /*  72 */ "arguments ::= PARENL argument_list PARENR",
 /*  73 */ "argument_list ::=",
 /*  74 */ "argument_list ::= assignment_expression",
 /*  75 */ "argument_list ::= argument_list COMMA assignment_expression",
 /*  76 */ "output_columns ::=",
 /*  77 */ "output_columns ::= output_column",
 /*  78 */ "output_columns ::= output_columns COMMA",
 /*  79 */ "output_columns ::= output_columns COMMA output_column",
 /*  80 */ "output_column ::= STAR",
 /*  81 */ "output_column ::= NONEXISTENT_COLUMN",
 /*  82 */ "output_column ::= assignment_expression",
 /*  83 */ "adjuster ::= adjuster PLUS adjust_expression",
 /*  84 */ "adjust_expression ::= adjust_match_expression STAR DECIMAL",
 /*  85 */ "adjust_match_expression ::= IDENTIFIER MATCH STRING",
 /*  86 */ "input ::= query",
 /*  87 */ "input ::= expression",
 /*  88 */ "input ::= START_OUTPUT_COLUMNS output_columns",
 /*  89 */ "input ::= START_ADJUSTER adjuster",
 /*  90 */ "query ::= query_element",
 /*  91 */ "query_element ::= QSTRING",
 /*  92 */ "query_element ::= PARENL query PARENR",
 /*  93 */ "expression ::= assignment_expression",
 /*  94 */ "assignment_expression ::= conditional_expression",
 /*  95 */ "conditional_expression ::= logical_or_expression",
 /*  96 */ "logical_or_expression ::= logical_and_expression",
 /*  97 */ "logical_and_expression ::= bitwise_or_expression",
 /*  98 */ "bitwise_or_expression ::= bitwise_xor_expression",
 /*  99 */ "bitwise_xor_expression ::= bitwise_and_expression",
 /* 100 */ "bitwise_and_expression ::= equality_expression",
 /* 101 */ "equality_expression ::= relational_expression",
 /* 102 */ "relational_expression ::= shift_expression",
 /* 103 */ "shift_expression ::= additive_expression",
 /* 104 */ "additive_expression ::= multiplicative_expression",
 /* 105 */ "multiplicative_expression ::= unary_expression",
 /* 106 */ "unary_expression ::= postfix_expression",
 /* 107 */ "postfix_expression ::= lefthand_side_expression",
 /* 108 */ "lefthand_side_expression ::= call_expression",
 /* 109 */ "lefthand_side_expression ::= member_expression",
 /* 110 */ "member_expression ::= primary_expression",
 /* 111 */ "member_expression ::= member_expression member_expression_part",
 /* 112 */ "primary_expression ::= object_literal",
 /* 113 */ "primary_expression ::= PARENL expression PARENR",
 /* 114 */ "primary_expression ::= IDENTIFIER",
 /* 115 */ "primary_expression ::= array_literal",
 /* 116 */ "primary_expression ::= DECIMAL",
 /* 117 */ "primary_expression ::= HEX_INTEGER",
 /* 118 */ "primary_expression ::= STRING",
 /* 119 */ "primary_expression ::= BOOLEAN",
 /* 120 */ "primary_expression ::= NULL",
 /* 121 */ "array_literal ::= BRACKETL elision BRACKETR",
 /* 122 */ "array_literal ::= BRACKETL element_list elision BRACKETR",
 /* 123 */ "array_literal ::= BRACKETL element_list BRACKETR",
 /* 124 */ "elision ::= COMMA",
 /* 125 */ "elision ::= elision COMMA",
 /* 126 */ "element_list ::= assignment_expression",
 /* 127 */ "element_list ::= elision assignment_expression",
 /* 128 */ "element_list ::= element_list elision assignment_expression",
 /* 129 */ "property_name_and_value_list ::= property_name_and_value",
 /* 130 */ "property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value",
 /* 131 */ "property_name ::= STRING",
 /* 132 */ "member_expression_part ::= DOT IDENTIFIER",
 /* 133 */ "adjuster ::=",
 /* 134 */ "adjuster ::= adjust_expression",
 /* 135 */ "adjust_expression ::= adjust_match_expression",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to grn_expr_parserAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void grn_expr_parserInit(void *yypParser){
  yyParser *pParser = (yyParser*)yypParser;
#ifdef YYTRACKMAXSTACKDEPTH
  pParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  pParser->yytos = NULL;
  pParser->yystack = NULL;
  pParser->yystksz = 0;
  if( yyGrowStack(pParser) ){
    pParser->yystack = &pParser->yystk0;
    pParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  pParser->yyerrcnt = -1;
#endif
  pParser->yytos = pParser->yystack;
  pParser->yystack[0].stateno = 0;
  pParser->yystack[0].major = 0;
}

#ifndef grn_expr_parser_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to grn_expr_parser and grn_expr_parserFree.
*/
void *grn_expr_parserAlloc(void *(*mallocProc)(YYMALLOCARGTYPE)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( pParser ) grn_expr_parserInit(pParser);
  return pParser;
}
#endif /* grn_expr_parser_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  grn_expr_parserARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
    case 76: /* suppress_unused_variable_warning */
{
#line 14 "grn_ecmascript.lemon"

  (void)efsi;

#line 1006 "grn_ecmascript.c"
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void grn_expr_parserFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef grn_expr_parser_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void grn_expr_parserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  grn_expr_parserFinalize(p);
  (*freeProc)(p);
}
#endif /* grn_expr_parser_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int grn_expr_parserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static unsigned int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yytos->stateno;
 
  if( stateno>=YY_MIN_REDUCE ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
  do{
    i = yy_shift_ofst[stateno];
    assert( iLookAhead!=YYNOCODE );
    i += iLookAhead;
    if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   grn_expr_parserARG_FETCH;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%sShift '%s', go to state %d\n",
         yyTracePrompt,yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%sShift '%s'\n",
         yyTracePrompt,yyTokenName[yypParser->yytos->major]);
    }
  }
}
#else
# define yyTraceShift(X,Y)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  grn_expr_parserTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>=&yypParser->yystack[YYSTACKDEPTH] ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState);
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 78, 2 },
  { 78, 3 },
  { 78, 3 },
  { 78, 3 },
  { 78, 3 },
  { 82, 2 },
  { 82, 2 },
  { 82, 3 },
  { 82, 3 },
  { 82, 2 },
  { 79, 3 },
  { 84, 3 },
  { 84, 3 },
  { 84, 3 },
  { 84, 3 },
  { 84, 3 },
  { 84, 3 },
  { 84, 3 },
  { 84, 3 },
  { 84, 3 },
  { 84, 3 },
  { 84, 3 },
  { 84, 3 },
  { 85, 5 },
  { 87, 3 },
  { 88, 3 },
  { 88, 3 },
  { 89, 3 },
  { 90, 3 },
  { 91, 3 },
  { 92, 3 },
  { 92, 3 },
  { 93, 3 },
  { 93, 3 },
  { 93, 3 },
  { 93, 3 },
  { 93, 3 },
  { 93, 3 },
  { 93, 3 },
  { 93, 3 },
  { 93, 3 },
  { 93, 3 },
  { 93, 3 },
  { 93, 3 },
  { 93, 3 },
  { 93, 3 },
  { 94, 3 },
  { 94, 3 },
  { 94, 3 },
  { 95, 3 },
  { 95, 3 },
  { 96, 3 },
  { 96, 3 },
  { 96, 3 },
  { 97, 2 },
  { 97, 2 },
  { 97, 2 },
  { 97, 2 },
  { 97, 2 },
  { 97, 2 },
  { 97, 2 },
  { 97, 2 },
  { 97, 2 },
  { 97, 2 },
  { 97, 2 },
  { 98, 2 },
  { 98, 2 },
  { 99, 2 },
  { 103, 3 },
  { 107, 0 },
  { 108, 3 },
  { 102, 3 },
  { 101, 3 },
  { 110, 0 },
  { 110, 1 },
  { 110, 3 },
  { 80, 0 },
  { 80, 1 },
  { 80, 2 },
  { 80, 3 },
  { 111, 1 },
  { 111, 1 },
  { 111, 1 },
  { 81, 3 },
  { 112, 3 },
  { 113, 3 },
  { 77, 1 },
  { 77, 1 },
  { 77, 2 },
  { 77, 2 },
  { 78, 1 },
  { 82, 1 },
  { 82, 3 },
  { 79, 1 },
  { 84, 1 },
  { 85, 1 },
  { 87, 1 },
  { 88, 1 },
  { 89, 1 },
  { 90, 1 },
  { 91, 1 },
  { 92, 1 },
  { 93, 1 },
  { 94, 1 },
  { 95, 1 },
  { 96, 1 },
  { 97, 1 },
  { 98, 1 },
  { 86, 1 },
  { 86, 1 },
  { 100, 1 },
  { 100, 2 },
  { 83, 1 },
  { 83, 3 },
  { 83, 1 },
  { 83, 1 },
  { 83, 1 },
  { 83, 1 },
  { 83, 1 },
  { 83, 1 },
  { 83, 1 },
  { 104, 3 },
  { 104, 4 },
  { 104, 3 },
  { 105, 1 },
  { 105, 2 },
  { 106, 1 },
  { 106, 2 },
  { 106, 3 },
  { 107, 1 },
  { 107, 3 },
  { 109, 1 },
  { 102, 2 },
  { 81, 0 },
  { 81, 1 },
  { 112, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno        /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  grn_expr_parserARG_FETCH;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    fprintf(yyTraceFILE, "%sReduce [%s], go to state %d.\n", yyTracePrompt,
      yyRuleName[yyruleno], yymsp[-yysize].stateno);
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=&yypParser->yystack[YYSTACKDEPTH-1] ){
      yyStackOverflow(yypParser);
      return;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        return;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* query ::= query query_element */
#line 53 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, grn_int32_value_at(&efsi->op_stack, -1), 2);
}
#line 1462 "grn_ecmascript.c"
        break;
      case 1: /* query ::= query LOGICAL_AND query_element */
      case 25: /* logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */ yytestcase(yyruleno==25);
#line 56 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND, 2);
}
#line 1470 "grn_ecmascript.c"
        break;
      case 2: /* query ::= query LOGICAL_AND_NOT query_element */
      case 26: /* logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */ yytestcase(yyruleno==26);
#line 59 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_NOT, 2);
}
#line 1478 "grn_ecmascript.c"
        break;
      case 3: /* query ::= query LOGICAL_OR query_element */
      case 24: /* logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */ yytestcase(yyruleno==24);
#line 62 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR, 2);
}
#line 1486 "grn_ecmascript.c"
        break;
      case 4: /* query ::= query NEGATIVE query_element */
#line 65 "grn_ecmascript.lemon"
{
  int weight;
  GRN_INT32_POP(&efsi->weight_stack, weight);
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ADJUST, 2);
}
#line 1495 "grn_ecmascript.c"
        break;
      case 5: /* query_element ::= ADJUST query_element */
#line 74 "grn_ecmascript.lemon"
{
  int weight;
  GRN_INT32_POP(&efsi->weight_stack, weight);
}
#line 1503 "grn_ecmascript.c"
        break;
      case 6: /* query_element ::= RELATIVE_OP query_element */
#line 78 "grn_ecmascript.lemon"
{
  int mode;
  GRN_INT32_POP(&efsi->mode_stack, mode);
}
#line 1511 "grn_ecmascript.c"
        break;
      case 7: /* query_element ::= IDENTIFIER RELATIVE_OP query_element */
#line 82 "grn_ecmascript.lemon"
{
  int mode;
  grn_obj *c;
  GRN_PTR_POP(&efsi->column_stack, c);
  GRN_INT32_POP(&efsi->mode_stack, mode);
  switch (mode) {
  case GRN_OP_NEAR :
  case GRN_OP_NEAR2 :
    {
      int max_interval;
      GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    }
    break;
  case GRN_OP_SIMILAR :
    {
      int similarity_threshold;
      GRN_INT32_POP(&efsi->similarity_threshold_stack, similarity_threshold);
    }
    break;
  default :
    break;
  }
}
#line 1538 "grn_ecmascript.c"
        break;
      case 8: /* query_element ::= BRACEL expression BRACER */
      case 9: /* query_element ::= EVAL primary_expression */ yytestcase(yyruleno==9);
#line 105 "grn_ecmascript.lemon"
{
  efsi->flags = efsi->default_flags;
}
#line 1546 "grn_ecmascript.c"
        break;
      case 10: /* expression ::= expression COMMA assignment_expression */
#line 113 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
}
#line 1553 "grn_ecmascript.c"
        break;
      case 11: /* assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
#line 118 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ASSIGN, 2);
}
#line 1560 "grn_ecmascript.c"
        break;
      case 12: /* assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
#line 121 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR_ASSIGN, 2);
}
#line 1567 "grn_ecmascript.c"
        break;
      case 13: /* assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
#line 124 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH_ASSIGN, 2);
}
#line 1574 "grn_ecmascript.c"
        break;
      case 14: /* assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
#line 127 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD_ASSIGN, 2);
}
#line 1581 "grn_ecmascript.c"
        break;
      case 15: /* assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
#line 130 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS_ASSIGN, 2);
}
#line 1588 "grn_ecmascript.c"
        break;
      case 16: /* assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
#line 133 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS_ASSIGN, 2);
}
#line 1595 "grn_ecmascript.c"
        break;
      case 17: /* assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
#line 136 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL_ASSIGN, 2);
}
#line 1602 "grn_ecmascript.c"
        break;
      case 18: /* assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
#line 139 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR_ASSIGN, 2);
}
#line 1609 "grn_ecmascript.c"
        break;
      case 19: /* assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
#line 142 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR_ASSIGN, 2);
}
#line 1616 "grn_ecmascript.c"
        break;
      case 20: /* assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
#line 145 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_ASSIGN, 2);
}
#line 1623 "grn_ecmascript.c"
        break;
      case 21: /* assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
#line 148 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_XOR_ASSIGN, 2);
}
#line 1630 "grn_ecmascript.c"
        break;
      case 22: /* assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
#line 151 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR_ASSIGN, 2);
}
#line 1637 "grn_ecmascript.c"
        break;
      case 23: /* conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
#line 156 "grn_ecmascript.lemon"
{
  grn_expr *e = (grn_expr *)efsi->e;
  e->codes[yymsp[-3].minor.yy0].nargs = yymsp[-1].minor.yy0 - yymsp[-3].minor.yy0;
  e->codes[yymsp[-1].minor.yy0].nargs = e->codes_curr - yymsp[-1].minor.yy0 - 1;
}
#line 1646 "grn_ecmascript.c"
        break;
      case 27: /* bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
#line 176 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_OR, 2);
}
#line 1653 "grn_ecmascript.c"
        break;
      case 28: /* bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
#line 181 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_XOR, 2);
}
#line 1660 "grn_ecmascript.c"
        break;
      case 29: /* bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
#line 186 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_AND, 2);
}
#line 1667 "grn_ecmascript.c"
        break;
      case 30: /* equality_expression ::= equality_expression EQUAL relational_expression */
#line 191 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EQUAL, 2);
}
#line 1674 "grn_ecmascript.c"
        break;
      case 31: /* equality_expression ::= equality_expression NOT_EQUAL relational_expression */
#line 194 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT_EQUAL, 2);
}
#line 1681 "grn_ecmascript.c"
        break;
      case 32: /* relational_expression ::= relational_expression LESS shift_expression */
#line 199 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS, 2);
}
#line 1688 "grn_ecmascript.c"
        break;
      case 33: /* relational_expression ::= relational_expression GREATER shift_expression */
#line 202 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER, 2);
}
#line 1695 "grn_ecmascript.c"
        break;
      case 34: /* relational_expression ::= relational_expression LESS_EQUAL shift_expression */
#line 205 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS_EQUAL, 2);
}
#line 1702 "grn_ecmascript.c"
        break;
      case 35: /* relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
#line 208 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER_EQUAL, 2);
}
#line 1709 "grn_ecmascript.c"
        break;
      case 36: /* relational_expression ::= relational_expression IN shift_expression */
#line 211 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_IN, 2);
}
#line 1716 "grn_ecmascript.c"
        break;
      case 37: /* relational_expression ::= relational_expression MATCH shift_expression */
      case 85: /* adjust_match_expression ::= IDENTIFIER MATCH STRING */ yytestcase(yyruleno==85);
#line 214 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MATCH, 2);
}
#line 1724 "grn_ecmascript.c"
        break;
      case 38: /* relational_expression ::= relational_expression NEAR shift_expression */
#line 217 "grn_ecmascript.lemon"
{
  {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR, 3);
}
#line 1737 "grn_ecmascript.c"
        break;
      case 39: /* relational_expression ::= relational_expression NEAR2 shift_expression */
#line 226 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR2, 2);
}
#line 1744 "grn_ecmascript.c"
        break;
      case 40: /* relational_expression ::= relational_expression SIMILAR shift_expression */
#line 229 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SIMILAR, 2);
}
#line 1751 "grn_ecmascript.c"
        break;
      case 41: /* relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
#line 232 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_TERM_EXTRACT, 2);
}
#line 1758 "grn_ecmascript.c"
        break;
      case 42: /* relational_expression ::= relational_expression LCP shift_expression */
#line 235 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LCP, 2);
}
#line 1765 "grn_ecmascript.c"
        break;
      case 43: /* relational_expression ::= relational_expression PREFIX shift_expression */
#line 238 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PREFIX, 2);
}
#line 1772 "grn_ecmascript.c"
        break;
      case 44: /* relational_expression ::= relational_expression SUFFIX shift_expression */
#line 241 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SUFFIX, 2);
}
#line 1779 "grn_ecmascript.c"
        break;
      case 45: /* relational_expression ::= relational_expression REGEXP shift_expression */
#line 244 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_REGEXP, 2);
}
#line 1786 "grn_ecmascript.c"
        break;
      case 46: /* shift_expression ::= shift_expression SHIFTL additive_expression */
#line 249 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL, 2);
}
#line 1793 "grn_ecmascript.c"
        break;
      case 47: /* shift_expression ::= shift_expression SHIFTR additive_expression */
#line 252 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR, 2);
}
#line 1800 "grn_ecmascript.c"
        break;
      case 48: /* shift_expression ::= shift_expression SHIFTRR additive_expression */
#line 255 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR, 2);
}
#line 1807 "grn_ecmascript.c"
        break;
      case 49: /* additive_expression ::= additive_expression PLUS multiplicative_expression */
      case 83: /* adjuster ::= adjuster PLUS adjust_expression */ yytestcase(yyruleno==83);
#line 260 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 2);
}
#line 1815 "grn_ecmascript.c"
        break;
      case 50: /* additive_expression ::= additive_expression MINUS multiplicative_expression */
#line 263 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 2);
}
#line 1822 "grn_ecmascript.c"
        break;
      case 51: /* multiplicative_expression ::= multiplicative_expression STAR unary_expression */
      case 84: /* adjust_expression ::= adjust_match_expression STAR DECIMAL */ yytestcase(yyruleno==84);
#line 268 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR, 2);
}
#line 1830 "grn_ecmascript.c"
        break;
      case 52: /* multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
#line 271 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH, 2);
}
#line 1837 "grn_ecmascript.c"
        break;
      case 53: /* multiplicative_expression ::= multiplicative_expression MOD unary_expression */
#line 274 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD, 2);
}
#line 1844 "grn_ecmascript.c"
        break;
      case 54: /* unary_expression ::= DELETE unary_expression */
#line 279 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DELETE, 1);
}
#line 1851 "grn_ecmascript.c"
        break;
      case 55: /* unary_expression ::= INCR unary_expression */
#line 282 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR, 1);
  }
}
#line 1872 "grn_ecmascript.c"
        break;
      case 56: /* unary_expression ::= DECR unary_expression */
#line 299 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR, 1);
  }
}
#line 1893 "grn_ecmascript.c"
        break;
      case 57: /* unary_expression ::= PLUS unary_expression */
#line 316 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 1);
}
#line 1900 "grn_ecmascript.c"
        break;
      case 58: /* unary_expression ::= MINUS unary_expression */
#line 319 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 1);
}
#line 1907 "grn_ecmascript.c"
        break;
      case 59: /* unary_expression ::= NOT unary_expression */
#line 322 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT, 1);
}
#line 1914 "grn_ecmascript.c"
        break;
      case 60: /* unary_expression ::= BITWISE_NOT unary_expression */
#line 325 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_NOT, 1);
}
#line 1921 "grn_ecmascript.c"
        break;
      case 61: /* unary_expression ::= ADJUST unary_expression */
#line 328 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ADJUST, 1);
}
#line 1928 "grn_ecmascript.c"
        break;
      case 62: /* unary_expression ::= EXACT unary_expression */
#line 331 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EXACT, 1);
}
#line 1935 "grn_ecmascript.c"
        break;
      case 63: /* unary_expression ::= PARTIAL unary_expression */
#line 334 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PARTIAL, 1);
}
#line 1942 "grn_ecmascript.c"
        break;
      case 64: /* unary_expression ::= UNSPLIT unary_expression */
#line 337 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_UNSPLIT, 1);
}
#line 1949 "grn_ecmascript.c"
        break;
      case 65: /* postfix_expression ::= lefthand_side_expression INCR */
#line 342 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR_POST, 1);
  }
}
#line 1970 "grn_ecmascript.c"
        break;
      case 66: /* postfix_expression ::= lefthand_side_expression DECR */
#line 359 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR_POST, 1);
  }
}
#line 1991 "grn_ecmascript.c"
        break;
      case 67: /* call_expression ::= member_expression arguments */
#line 380 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_CALL, yymsp[0].minor.yy0);
}
#line 1998 "grn_ecmascript.c"
        break;
      case 68: /* object_literal ::= BRACEL property_name_and_value_list BRACER */
#line 408 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr_take_obj(ctx, efsi->e, (grn_obj *)(efsi->object_literal));
  grn_expr_append_obj(ctx, efsi->e, (grn_obj *)(efsi->object_literal),
                      GRN_OP_PUSH, 1);
  efsi->object_literal = NULL;
}
#line 2009 "grn_ecmascript.c"
        break;
      case 69: /* property_name_and_value_list ::= */
#line 416 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;

  efsi->object_literal =
    grn_hash_create(ctx, NULL, GRN_TABLE_MAX_KEY_SIZE, sizeof(grn_obj),
                    GRN_OBJ_KEY_VAR_SIZE|GRN_OBJ_TEMPORARY|GRN_HASH_TINY);
  if (!efsi->object_literal) {
    ERR(GRN_NO_MEMORY_AVAILABLE,
        "couldn't create hash table for parsing object literal: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  }
}
#line 2025 "grn_ecmascript.c"
        break;
      case 70: /* property_name_and_value ::= property_name COLON assignment_expression */
#line 431 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_obj *property = e->codes[e->codes_curr - 3].value;
  grn_obj *value = e->codes[e->codes_curr - 1].value;

  if (!efsi->object_literal) {
     efsi->object_literal =
       grn_hash_create(ctx, NULL, GRN_TABLE_MAX_KEY_SIZE, sizeof(grn_obj),
                       GRN_OBJ_KEY_VAR_SIZE|GRN_OBJ_TEMPORARY|GRN_HASH_TINY);
  }

  if (!efsi->object_literal) {
    ERR(GRN_NO_MEMORY_AVAILABLE,
        "couldn't create hash table for parsing object literal: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_obj *buf;
    int added;
    if (grn_hash_add(ctx, (grn_hash *)efsi->object_literal,
                     GRN_TEXT_VALUE(property), GRN_TEXT_LEN(property),
                     (void **)&buf, &added)) {
      if (added) {
        GRN_OBJ_INIT(buf, value->header.type, 0, value->header.domain);
        GRN_TEXT_PUT(ctx, buf, GRN_TEXT_VALUE(value), GRN_TEXT_LEN(value));
        grn_expr_dfi_pop(e);
        e->codes_curr -= 3;
      } else {
        ERR(GRN_INVALID_ARGUMENT,
            "duplicated property name: <%.*s>",
            (int)GRN_TEXT_LEN(property),
            GRN_TEXT_VALUE(property));
      }
    } else {
      ERR(GRN_NO_MEMORY_AVAILABLE,
          "failed to add a property to object literal: <%.*s>",
          (int)GRN_TEXT_LEN(property),
          GRN_TEXT_VALUE(property));
    }
  }
}
#line 2070 "grn_ecmascript.c"
        break;
      case 71: /* member_expression_part ::= BRACKETL expression BRACKETR */
#line 475 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GET_MEMBER, 2);
}
#line 2077 "grn_ecmascript.c"
        break;
      case 72: /* arguments ::= PARENL argument_list PARENR */
#line 480 "grn_ecmascript.lemon"
{ yymsp[-2].minor.yy0 = yymsp[-1].minor.yy0; }
#line 2082 "grn_ecmascript.c"
        break;
      case 73: /* argument_list ::= */
#line 481 "grn_ecmascript.lemon"
{ yymsp[1].minor.yy0 = 0; }
#line 2087 "grn_ecmascript.c"
        break;
      case 74: /* argument_list ::= assignment_expression */
#line 482 "grn_ecmascript.lemon"
{ yymsp[0].minor.yy0 = 1; }
#line 2092 "grn_ecmascript.c"
        break;
      case 75: /* argument_list ::= argument_list COMMA assignment_expression */
#line 483 "grn_ecmascript.lemon"
{ yylhsminor.yy0 = yymsp[-2].minor.yy0 + 1; }
#line 2097 "grn_ecmascript.c"
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 76: /* output_columns ::= */
#line 485 "grn_ecmascript.lemon"
{
  yymsp[1].minor.yy0 = 0;
}
#line 2105 "grn_ecmascript.c"
        break;
      case 77: /* output_columns ::= output_column */
#line 488 "grn_ecmascript.lemon"
{
  yylhsminor.yy0 = yymsp[0].minor.yy0;
}
#line 2112 "grn_ecmascript.c"
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 78: /* output_columns ::= output_columns COMMA */
#line 493 "grn_ecmascript.lemon"
{
  yylhsminor.yy0 = yymsp[-1].minor.yy0;
}
#line 2120 "grn_ecmascript.c"
  yymsp[-1].minor.yy0 = yylhsminor.yy0;
        break;
      case 79: /* output_columns ::= output_columns COMMA output_column */
#line 498 "grn_ecmascript.lemon"
{
  if (yymsp[-2].minor.yy0 == 0) {
    yylhsminor.yy0 = yymsp[0].minor.yy0;
  } else if (yymsp[0].minor.yy0 == 0) {
    yylhsminor.yy0 = yymsp[-2].minor.yy0;
  } else {
    if (yymsp[0].minor.yy0 == 1) {
      grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
    }
    yylhsminor.yy0 = 1;
  }
}
#line 2137 "grn_ecmascript.c"
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 80: /* output_column ::= STAR */
#line 511 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_obj *expr = efsi->e;
  grn_obj *variable = grn_expr_get_var_by_offset(ctx, expr, 0);
  if (variable) {
    grn_id table_id = GRN_OBJ_GET_DOMAIN(variable);
    grn_obj *table = grn_ctx_at(ctx, table_id);
    grn_obj columns_buffer;
    int n_columns;
    grn_obj **columns;

    GRN_PTR_INIT(&columns_buffer, GRN_OBJ_VECTOR, GRN_ID_NIL);
    grn_obj_columns(ctx, table, "*", strlen("*"), &columns_buffer);
    n_columns = GRN_BULK_VSIZE(&columns_buffer) / sizeof(grn_obj *);
    columns = (grn_obj **)GRN_BULK_HEAD(&columns_buffer);

    if (n_columns == 0) {
      /* do nothing */
    } else if (n_columns == 1) {
      grn_obj *column = columns[0];
      grn_expr_append_const(ctx, expr, column, GRN_OP_GET_VALUE, 1);
      if (column->header.type == GRN_ACCESSOR) {
        grn_expr_take_obj(ctx, expr, column);
      }
    } else {
      grn_expr *e = (grn_expr *)expr;
      grn_bool have_column;
      int i;

      have_column = (e->codes_curr > 0);
      for (i = 0; i < n_columns; i++) {
        grn_obj *column = columns[i];
        grn_expr_append_const(ctx, expr, column, GRN_OP_GET_VALUE, 1);
        if (have_column || i > 0) {
          grn_expr_append_op(ctx, expr, GRN_OP_COMMA, 2);
        }
        if (column->header.type == GRN_ACCESSOR) {
          grn_expr_take_obj(ctx, expr, column);
        }
      }
    }

    GRN_OBJ_FIN(ctx, &columns_buffer);

    yymsp[0].minor.yy0 = n_columns;
  } else {
    /* TODO: report error */
    yymsp[0].minor.yy0 = 0;
  }
}
#line 2192 "grn_ecmascript.c"
        break;
      case 81: /* output_column ::= NONEXISTENT_COLUMN */
#line 561 "grn_ecmascript.lemon"
{
  yymsp[0].minor.yy0 = 0;
}
#line 2199 "grn_ecmascript.c"
        break;
      case 82: /* output_column ::= assignment_expression */
#line 564 "grn_ecmascript.lemon"
{
  yymsp[0].minor.yy0 = 1;
}
#line 2206 "grn_ecmascript.c"
        break;
      default:
      /* (86) input ::= query */ yytestcase(yyruleno==86);
      /* (87) input ::= expression */ yytestcase(yyruleno==87);
      /* (88) input ::= START_OUTPUT_COLUMNS output_columns */ yytestcase(yyruleno==88);
      /* (89) input ::= START_ADJUSTER adjuster */ yytestcase(yyruleno==89);
      /* (90) query ::= query_element (OPTIMIZED OUT) */ assert(yyruleno!=90);
      /* (91) query_element ::= QSTRING */ yytestcase(yyruleno==91);
      /* (92) query_element ::= PARENL query PARENR */ yytestcase(yyruleno==92);
      /* (93) expression ::= assignment_expression (OPTIMIZED OUT) */ assert(yyruleno!=93);
      /* (94) assignment_expression ::= conditional_expression (OPTIMIZED OUT) */ assert(yyruleno!=94);
      /* (95) conditional_expression ::= logical_or_expression */ yytestcase(yyruleno==95);
      /* (96) logical_or_expression ::= logical_and_expression */ yytestcase(yyruleno==96);
      /* (97) logical_and_expression ::= bitwise_or_expression */ yytestcase(yyruleno==97);
      /* (98) bitwise_or_expression ::= bitwise_xor_expression */ yytestcase(yyruleno==98);
      /* (99) bitwise_xor_expression ::= bitwise_and_expression */ yytestcase(yyruleno==99);
      /* (100) bitwise_and_expression ::= equality_expression */ yytestcase(yyruleno==100);
      /* (101) equality_expression ::= relational_expression */ yytestcase(yyruleno==101);
      /* (102) relational_expression ::= shift_expression */ yytestcase(yyruleno==102);
      /* (103) shift_expression ::= additive_expression */ yytestcase(yyruleno==103);
      /* (104) additive_expression ::= multiplicative_expression */ yytestcase(yyruleno==104);
      /* (105) multiplicative_expression ::= unary_expression (OPTIMIZED OUT) */ assert(yyruleno!=105);
      /* (106) unary_expression ::= postfix_expression (OPTIMIZED OUT) */ assert(yyruleno!=106);
      /* (107) postfix_expression ::= lefthand_side_expression */ yytestcase(yyruleno==107);
      /* (108) lefthand_side_expression ::= call_expression (OPTIMIZED OUT) */ assert(yyruleno!=108);
      /* (109) lefthand_side_expression ::= member_expression */ yytestcase(yyruleno==109);
      /* (110) member_expression ::= primary_expression (OPTIMIZED OUT) */ assert(yyruleno!=110);
      /* (111) member_expression ::= member_expression member_expression_part */ yytestcase(yyruleno==111);
      /* (112) primary_expression ::= object_literal (OPTIMIZED OUT) */ assert(yyruleno!=112);
      /* (113) primary_expression ::= PARENL expression PARENR */ yytestcase(yyruleno==113);
      /* (114) primary_expression ::= IDENTIFIER */ yytestcase(yyruleno==114);
      /* (115) primary_expression ::= array_literal (OPTIMIZED OUT) */ assert(yyruleno!=115);
      /* (116) primary_expression ::= DECIMAL */ yytestcase(yyruleno==116);
      /* (117) primary_expression ::= HEX_INTEGER */ yytestcase(yyruleno==117);
      /* (118) primary_expression ::= STRING */ yytestcase(yyruleno==118);
      /* (119) primary_expression ::= BOOLEAN */ yytestcase(yyruleno==119);
      /* (120) primary_expression ::= NULL */ yytestcase(yyruleno==120);
      /* (121) array_literal ::= BRACKETL elision BRACKETR */ yytestcase(yyruleno==121);
      /* (122) array_literal ::= BRACKETL element_list elision BRACKETR */ yytestcase(yyruleno==122);
      /* (123) array_literal ::= BRACKETL element_list BRACKETR */ yytestcase(yyruleno==123);
      /* (124) elision ::= COMMA */ yytestcase(yyruleno==124);
      /* (125) elision ::= elision COMMA */ yytestcase(yyruleno==125);
      /* (126) element_list ::= assignment_expression (OPTIMIZED OUT) */ assert(yyruleno!=126);
      /* (127) element_list ::= elision assignment_expression */ yytestcase(yyruleno==127);
      /* (128) element_list ::= element_list elision assignment_expression */ yytestcase(yyruleno==128);
      /* (129) property_name_and_value_list ::= property_name_and_value (OPTIMIZED OUT) */ assert(yyruleno!=129);
      /* (130) property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value */ yytestcase(yyruleno==130);
      /* (131) property_name ::= STRING */ yytestcase(yyruleno==131);
      /* (132) member_expression_part ::= DOT IDENTIFIER */ yytestcase(yyruleno==132);
      /* (133) adjuster ::= */ yytestcase(yyruleno==133);
      /* (134) adjuster ::= adjust_expression (OPTIMIZED OUT) */ assert(yyruleno!=134);
      /* (135) adjust_expression ::= adjust_match_expression */ yytestcase(yyruleno==135);
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact <= YY_MAX_SHIFTREDUCE ){
    if( yyact>YY_MAX_SHIFT ){
      yyact += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
    }
    yymsp -= yysize-1;
    yypParser->yytos = yymsp;
    yymsp->stateno = (YYACTIONTYPE)yyact;
    yymsp->major = (YYCODETYPE)yygoto;
    yyTraceShift(yypParser, yyact);
  }else{
    assert( yyact == YY_ACCEPT_ACTION );
    yypParser->yytos -= yysize;
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  grn_expr_parserTOKENTYPE yyminor         /* The minor type of the error token */
){
  grn_expr_parserARG_FETCH;
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/
#line 20 "grn_ecmascript.lemon"

  {
    grn_ctx *ctx = efsi->ctx;
    grn_obj message;
    GRN_TEXT_INIT(&message, 0);
    GRN_TEXT_PUT(ctx, &message, efsi->str, efsi->cur - efsi->str);
    GRN_TEXT_PUTC(ctx, &message, '|');
    if (efsi->cur < efsi->str_end) {
      GRN_TEXT_PUTC(ctx, &message, efsi->cur[0]);
      GRN_TEXT_PUTC(ctx, &message, '|');
      GRN_TEXT_PUT(ctx, &message,
                   efsi->cur + 1, efsi->str_end - (efsi->cur + 1));
    } else {
      GRN_TEXT_PUTC(ctx, &message, '|');
    }
    if (ctx->rc == GRN_SUCCESS) {
      ERR(GRN_SYNTAX_ERROR, "Syntax error: <%.*s>",
          (int)GRN_TEXT_LEN(&message), GRN_TEXT_VALUE(&message));
    } else {
      ERR(ctx->rc, "Syntax error: <%.*s>: %s",
          (int)GRN_TEXT_LEN(&message), GRN_TEXT_VALUE(&message),
          ctx->errbuf);
    }
    GRN_OBJ_FIN(ctx, &message);
  }
#line 2341 "grn_ecmascript.c"
/************ End %syntax_error code ******************************************/
  grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "grn_expr_parserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  grn_expr_parserTOKENTYPE yyminor       /* The value for the token */
  grn_expr_parserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  unsigned int yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  yypParser = (yyParser*)yyp;
  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif
  grn_expr_parserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput '%s'\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      yymajor = YYNOCODE;
    }else if( yyact <= YY_MAX_REDUCE ){
      yy_reduce(yypParser,yyact-YY_MIN_REDUCE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && yymx != YYERRORSYMBOL
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) >= YY_MIN_REDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;
      
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}
